<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Kit;
use Elementor\Core\Kits\Documents\Tabs\Tab_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Liquid_Global_Sidebar extends Tab_Base {

	public function __construct( $parent ) {
		parent::__construct( $parent );

		Controls_Manager::add_tab( $this->get_id(), $this->get_title() );
	}

	public function get_id() {
		return 'liquid-sidebar-kit';
	}

	public function get_title() {
		return __( 'Sidebars', 'logistics-hub-core' );
	}

	public function get_group() {
		return 'settings';
	}

	public function get_icon() {
		return 'eicon-sidebar';
	}

	public function get_help_url() {
		return 'https://docs.liquid-themes.com/';
	}

	protected function register_tab_controls() {

		$this->start_controls_section(
			'section_' . $this->get_id() . '_add_sidebars',
			[
				'label' => esc_html__('Add sidebars', 'logistics-hub-core'),
				'tab' => $this->get_id(),
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'liquid_custom_sidebars',
			[
				'label' => esc_html__( 'Sidebars', 'logistics-hub-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'liquid_sidebar_widgets_style',
			[
				'label' => esc_html__( 'Sidebar Style', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'sidebar-widgets-outline',
				'options' => [
					'sidebar-widgets-default'  => esc_html__( 'Default', 'logistics-hub-core' ),
					'sidebar-widgets-outline'  => esc_html__( 'Outline', 'logistics-hub-core' ),
				],
			]
		);

		$this->add_responsive_control(
			'liquid_sidebar_top_spacing',
			[
				'label' => esc_html__( 'Sidebar Top Spacing', 'logistics-hub-core' ),
				'description' => esc_html__( 'Manages the spacing between sidebar and titlbar.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 25,
				],
				'selectors' => [
					'{{WRAPPER}}.has-sidebar #lqd-contents-wrap' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Sidebar manager
		$this->start_controls_section(
			'section_' . $this->get_id() . '_manage',
			[
				'label' => esc_html__('Sidebar manager', 'logistics-hub-core'),
				'tab' => $this->get_id(),
			]
		);

		$repeater = new \Elementor\Repeater();


		$repeater->add_control(
			'enable',
			[
				'label' => esc_html__( 'Enable this rule', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'On', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Off', 'logistics-hub-core' ),
				'return_value' => 'on',
			]
		);

		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'Sidebar Rule', 'logistics-hub-core' ),
				'placeholder' => esc_html__( 'Type your title here', 'logistics-hub-core' ),
			]
		);

		$repeater->add_control(
			'archive',
			[
				'label' => esc_html__( 'Select archive', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'label_block' => true,
				'options' => [
					'page'  => esc_html__( 'Page', 'logistics-hub-core' ),
					'blog-posts'  => esc_html__( 'Blog Posts', 'logistics-hub-core' ),
					'blog-archive'  => esc_html__( 'Blog Archive', 'logistics-hub-core' ),
					'portfolio-posts' => esc_html__( 'Portfolio Posts', 'logistics-hub-core' ),
					'portfolio-archive' => esc_html__( 'Portfolio Archive', 'logistics-hub-core' ),
					'search-page' => esc_html__( 'Portfolio Posts', 'logistics-hub-core' ),
					'product-single' => esc_html__( 'Product', 'logistics-hub-core' ),
					'product-archive' => esc_html__( 'Product Archive', 'logistics-hub-core' ),
				],
			]
		);

		$repeater->add_control(
			'enable_shop',
			[
				'label' => esc_html__( 'Enable also for shop page', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'On', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Off', 'logistics-hub-core' ),
				'return_value' => 'enable_shop',
				'condition' => [
					'archive' => 'product-archive',
				],
			]
		);

		$repeater->add_control(
			'hide_on_mobile',
			[
				'label' => esc_html__( 'Hide on mobile', 'logistics-hub-core' ),
				'description' => esc_html__( 'Hide sidebar on mobile devices.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'On', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Off', 'logistics-hub-core' ),
				'return_value' => 'on',
			]
		);

		$repeater->add_control(
			'sidebar',
			[
				'label' => __( 'Select sidebar', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'options' => liquid_helper()->get_sidebars( array('main' => esc_html__( 'Main Sidebar', 'logistics-hub-core' ) ) ),
				'default' => 'main',
				'save_default' => true,
			]
		);

		$repeater->add_control(
			'position',
			[
				'label' => esc_html__( 'Position', 'logistics-hub-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'logistics-hub-core' ),
						'icon' => 'eicon-h-align-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'logistics-hub-core' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'right',
				'toggle' => false,
			]
		);

		$this->add_control(
			'liquid_sidebar_manager',
			[
				'label' => esc_html__( 'Rules', 'logistics-hub-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

	}

}

new Liquid_Global_Sidebar( Kit::class );

add_action(
	'elementor/kit/register_tabs',
	function( $kit ) {
		$kit->register_tab( 'liquid-sidebar-kit', Liquid_Global_Sidebar::class );
	}
);
